/*
 * @(#)ElementListener.java  1.0  2. Dezember 2003
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.simulation;

/**
 * ElementListener.
 *
 * @author  Werner Randelshofer
 * @version 1.0 2. Dezember 2003  Created.
 */
public interface SimulatedObjectListener extends java.util.EventListener {
    /**
     * Sent after a relationship has been added to an element.
     */
    public void relationshipAdded(SimulatedObjectEvent e);
    /**
     * Sent after a relationship has been removed from an element.
     */
    public void relationshipRemoved(SimulatedObjectEvent e);
    
    /**
     * Sent when the state of a simulated object has changed.
     */
    public void objectChanged(SimulatedObjectEvent e);
    
    /**
     * Sent when an object was added to a simulation.
     */
    public void objectAdded(SimulatedObjectEvent e);
    /**
     * Sent when an object was removed from a simulation.
     */
    public void objectRemoved(SimulatedObjectEvent e);
    /**
     * Sent when requesting to remove an object from its simulation.
     */
    public void objectRequestRemove(SimulatedObjectEvent e);
}
